const { app, BrowserWindow } = require('electron');
const path = require('path');
const { ipcMain } = require('electron');
const fs = require('fs');
var force_quit = false;
// Handle creating/removing shortcuts on Windows when installing/uninstalling.
if (require('electron-squirrel-startup')) { // eslint-disable-line global-require
    app.quit();
}

let rawdata = fs.readFileSync(path.resolve(__dirname, 'env-config.json'));
let config = JSON.parse(rawdata);



ipcMain.on('close-me', (evt, arg) => {
    force_quit = true;
    app.quit();
})
const createWindow = () => {
    // Create the browser window.
    const mainWindow = new BrowserWindow({
        width: 400, // Perfect Width for view
        // width: 1000, // For Testing Purpose
        height: 580,
        icon: __dirname + config.LOGO,
        webPreferences: {
            nodeIntegration: true,
            contextIsolation: false,
            enableRemoteModule: true,
        },
        resizable: true
    });

    // mainWindow.maximize();
    mainWindow.show();
    mainWindow.removeMenu();

    // and load the index.html of the app.
    mainWindow.loadFile(path.join(__dirname, 'index.html'));

    // Open the DevTools.
    // mainWindow.webContents.openDevTools();
    mainWindow.on('close', function(e) {
        if (!force_quit) {
            e.preventDefault();
        }
    });
    // mainWindow.on("close", (e) => {
    //     e.preventDefault();
    //     // var check = document.getElementById("time-tracking").getAttribute("data-tracking");
    //     // if(check == 'on'){
    //     //     if(confirm('Tracker is On . are you sore close app ?')){
    //     //         document.getElementById("time-tracking").click();
    //     //         setTimeout(function(){
    //     //             mainWindow.hide();
    //     //         },300)
    //     //         console.log('yes')
    //     //     }else{
    //     //         console.log('no');
    //     //     }
    //     // }else{
    //     //     mainWindow.hide();
    //     // }
    //     // Dereference the window object, usually you would store windows
    //     // in an array if your app supports multi windows, this is the time
    //     // when you should delete the corresponding element.
    //     // mainWindow = null;
    // });
    mainWindow.on('closed', function() {
        console.log("closed");
        mainWindow = null;
        app.quit();
    });
};

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
// app.on('ready', createWindow);
app.on('ready', function() {
    createWindow();
});
// Quit when all windows are closed, except on macOS. There, it's common
// for applications and their menu bar to stay active until the user quits
// explicitly with Cmd + Q.
app.on('window-all-closed', () => {
    // if (process.platform !== 'darwin') {
    //     app.quit();
    // }
});

app.on('activate', () => {
    // On OS X it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (BrowserWindow.getAllWindows().length === 0) {
        createWindow();
    }
});

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and import them here.