@extends('layouts.admin')
@section('page-title')
    {{ __('Dashboard') }}
@endsection

@push('css-page')
    <style>
        .apexcharts-yaxis {
            transform: translate(20px, 0px) !important;
        }
    </style>
@endpush

@push('theme-script')
    <script src="{{ asset('assets/libs/apexcharts/dist/apexcharts.min.js') }}"></script>
@endpush
@push('script-page')
    <script>
        (function() {
            var chartBarOptions = {
                series: [{
                    name: '{{ __('Income') }}',
                    data: {!! json_encode($chartData['data']) !!},

                }, ],

                chart: {
                    height: 300,
                    type: 'area',
                    // type: 'line',
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.2
                    },
                    toolbar: {
                        show: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                title: {
                    text: '',
                    align: 'left'
                },
                xaxis: {
                    categories: {!! json_encode($chartData['label']) !!},
                    title: {
                        text: '{{ __('Months') }}'
                    }
                },
                colors: ['#6fd944', '#6fd944'],

                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                // markers: {
                //     size: 4,
                //     colors: ['#ffa21d', '#FF3A6E'],
                //     opacity: 0.9,
                //     strokeWidth: 2,
                //     hover: {
                //         size: 7,
                //     }
                // },
                yaxis: {
                    title: {
                        text: '{{ __('Income') }}',
                        offsetX: 30,
                        offsetY: -10,
                    },

                }

            };
            var arChart = new ApexCharts(document.querySelector("#chart-sales"), chartBarOptions);
            arChart.render();
        })();
    </script>
@endpush
@php
    $admin_payment_setting = Utility::getAdminPaymentSetting();
@endphp

@section('content')
<div class="row mb-4 gy-4">
    <div class="col-xxl-4 col-md-6 col-12 dash-info-card super-admin">
        <div class="info-card-inner card mb-0">
            <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path opacity="0.4"
                    d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                    fill="#FF3A6E" />
                <path opacity="0.4"
                    d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                    fill="#FF3A6E" />
            </svg>
            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                    fill="#FF3A6E"></path>
            </svg>
            <div class="info-icon-wrp d-flex flex-wrap align-items-start justify-content-between gap-2 mb-3">
                <div class="info-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_63_1528)">
                            <path
                                d="M12 9.68585C14.2523 9.68585 16.0781 7.86001 16.0781 5.60773C16.0781 3.35544 14.2523 1.5296 12 1.5296C9.74771 1.5296 7.92188 3.35544 7.92188 5.60773C7.92188 7.86001 9.74771 9.68585 12 9.68585Z"
                                fill="white" />
                            <path
                                d="M20.25 9.68579C21.6739 9.68579 22.8281 8.53153 22.8281 7.10767C22.8281 5.68381 21.6739 4.52954 20.25 4.52954C18.8261 4.52954 17.6719 5.68381 17.6719 7.10767C17.6719 8.53153 18.8261 9.68579 20.25 9.68579Z"
                                fill="white" />
                            <path
                                d="M3.75 9.68579C5.17386 9.68579 6.32812 8.53153 6.32812 7.10767C6.32812 5.68381 5.17386 4.52954 3.75 4.52954C2.32614 4.52954 1.17188 5.68381 1.17188 7.10767C1.17188 8.53153 2.32614 9.68579 3.75 9.68579Z"
                                fill="white" />
                            <path
                                d="M6.29016 12.001C5.27531 11.1695 4.35623 11.2796 3.18281 11.2796C1.42781 11.2796 0 12.699 0 14.4432V19.5624C0 20.3199 0.618281 20.9359 1.37859 20.9359C4.66106 20.9359 4.26562 20.9952 4.26562 20.7943C4.26562 17.1668 3.83597 14.5066 6.29016 12.001Z"
                                fill="white" />
                            <path
                                d="M13.1161 11.2983C11.0665 11.1273 9.28506 11.3003 7.74845 12.5686C5.17703 14.6283 5.67189 17.4016 5.67189 20.7942C5.67189 21.6918 6.4022 22.4358 7.31345 22.4358C17.2079 22.4358 17.6017 22.755 18.1885 21.4556C18.3809 21.0162 18.3281 21.1559 18.3281 16.9524C18.3281 13.6136 15.4372 11.2983 13.1161 11.2983Z"
                                fill="white" />
                            <path
                                d="M20.8172 11.2795C19.6373 11.2795 18.7233 11.1706 17.7098 12.001C20.1457 14.488 19.7344 16.9667 19.7344 20.7942C19.7344 20.9965 19.4061 20.9358 22.5722 20.9358C23.3597 20.9358 24 20.2978 24 19.5136V14.4431C24 12.6989 22.5722 11.2795 20.8172 11.2795Z"
                                fill="white" />
                        </g>
                        <defs>
                            <clipPath id="clip0_63_1528">
                                <rect width="24" height="24" fill="white" />
                            </clipPath>
                        </defs>
                    </svg>
                </div>
                <div class="card-label">
                    {{ __('Paid Users : ') }}
                    <span>{{ $user['total_paid_user'] }}</span>
                </div>
            </div>
            <div class="info-content d-flex align-items-center gap-3 flex-wrap">
                <h2 class="h4 mb-0 info-link">{{ __('Total Companies') }}</h2>
                <h3 class="mb-0">{{ $user->total_user }}</h3>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-12 dash-info-card super-admin">
        <div class="info-card-inner card mb-0">
            <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path opacity="0.4"
                    d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                    fill="#FF3A6E" />
                <path opacity="0.4"
                    d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                    fill="#FF3A6E" />
            </svg>
            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                    fill="#FF3A6E"></path>
            </svg>
            <div class="info-icon-wrp d-flex flex-wrap align-items-start justify-content-between gap-2 mb-3">
                <div class="info-icon">
                    <svg width="29" height="29" viewBox="0 0 29 29" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M10.8504 26.731C10.4571 26.7326 10.0793 26.5779 9.80013 26.3009C9.52094 26.0239 9.36321 25.6474 9.36164 25.2542C9.36007 24.8609 9.51478 24.4831 9.79174 24.2039C10.0687 23.9247 10.4452 23.767 10.8385 23.7654H10.8504C11.2436 23.7654 11.6208 23.9217 11.8988 24.1997C12.1769 24.4778 12.3331 24.855 12.3331 25.2482C12.3331 25.6415 12.1769 26.0186 11.8988 26.2967C11.6208 26.5748 11.2436 26.731 10.8504 26.731ZM21.823 25.2482C21.823 24.855 21.6668 24.4778 21.3887 24.1997C21.1106 23.9217 20.7335 23.7654 20.3402 23.7654H20.3283C20.0356 23.7678 19.7501 23.8567 19.5078 24.0211C19.2655 24.1854 19.0773 24.4178 18.9669 24.689C18.8565 24.9601 18.8288 25.2579 18.8874 25.5447C18.9459 25.8315 19.0881 26.0946 19.2959 26.3008C19.5037 26.507 19.768 26.6471 20.0553 26.7033C20.3426 26.7596 20.6401 26.7295 20.9103 26.617C21.1806 26.5044 21.4115 26.3143 21.5739 26.0708C21.7363 25.8272 21.823 25.541 21.823 25.2482ZM25.0128 10.2543L23.8147 17.5852C23.7993 18.0148 23.6936 18.4364 23.5044 18.8225C23.3152 19.2085 23.0468 19.5503 22.7166 19.8257C22.3864 20.101 22.0019 20.3037 21.5882 20.4204C21.1744 20.5372 20.7407 20.5654 20.3153 20.5033H10.5052C9.93314 20.5047 9.37998 20.2988 8.94814 19.9236C8.5163 19.5485 8.23503 19.0296 8.15643 18.463L6.3759 6.06926C6.32937 5.71298 6.15434 5.38596 5.88371 5.14962C5.61308 4.91328 5.26546 4.78389 4.90616 4.78576H4.59774C4.36179 4.78576 4.13549 4.69203 3.96865 4.52518C3.8018 4.35833 3.70807 4.13204 3.70807 3.89609C3.70807 3.66013 3.8018 3.43384 3.96865 3.26699C4.13549 3.10015 4.36179 3.00641 4.59774 3.00641H4.90616C5.6933 3.00136 6.45531 3.28328 7.04962 3.79943C7.64393 4.31558 8.02981 5.03058 8.13508 5.81066L8.383 7.45478H22.6877C23.0347 7.45605 23.3772 7.53342 23.6911 7.68144C24.0049 7.82945 24.2825 8.04451 24.5042 8.31145C24.7259 8.57839 24.8863 8.89071 24.9742 9.22639C25.062 9.56208 25.0752 9.91295 25.0128 10.2543ZM18.5442 11.7679C18.4616 11.6852 18.3635 11.6196 18.2555 11.5749C18.1476 11.5302 18.0318 11.5071 17.9149 11.5071C17.7981 11.5071 17.6823 11.5302 17.5744 11.5749C17.4664 11.6196 17.3683 11.6852 17.2857 11.7679L14.7519 14.3017L13.8029 13.3527C13.6352 13.1906 13.4105 13.1008 13.1772 13.1027C12.9439 13.1046 12.7207 13.1981 12.5557 13.363C12.3907 13.5278 12.297 13.7509 12.2949 13.9842C12.2927 14.2175 12.3823 14.4422 12.5443 14.6101L14.1255 16.1925C14.2927 16.3589 14.519 16.4523 14.7548 16.4523C14.9907 16.4523 15.217 16.3589 15.3841 16.1925L18.5442 13.0301C18.6275 12.9474 18.6935 12.849 18.7385 12.7407C18.7836 12.6324 18.8068 12.5163 18.8068 12.399C18.8068 12.2817 18.7836 12.1655 18.7385 12.0572C18.6935 11.9489 18.6275 11.8506 18.5442 11.7679Z"
                            fill="white" />
                    </svg>
                </div>
                <div class="card-label">
                    {{ __('Total Order Amount : ') }}
                    <span>{{ env('CURRENCY_SYMBOL') }}{{ $user['total_orders_price'] }}</span>
                </div>
            </div>
            <div class="info-content d-flex align-items-center gap-3 flex-wrap">
                <h2 class="h4 mb-0 info-link">{{ __('Total Orders') }}</h2>
                <h3 class="mb-0">{{ $user->total_orders }}</h3>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-md-6 col-12 dash-info-card super-admin">
        <div class="info-card-inner card mb-0">
            <svg class="star-bg" width="83" height="79" viewBox="0 0 83 79" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path opacity="0.4"
                    d="M59.0537 26.924C44.68 38.2757 42.7394 43.5902 45.6923 63.5089C34.0866 47.0541 29.0147 44.5469 10.7783 46.2497C25.1511 34.8957 27.0918 29.5812 24.1367 9.66327C35.7446 26.1172 40.8164 28.6245 59.0537 26.924Z"
                    fill="#FF3A6E" />
                <path opacity="0.4"
                    d="M78.2765 61.7004C73.0978 65.7903 72.3986 67.705 73.4625 74.8815C69.2811 68.953 67.4538 68.0497 60.8834 68.6632C66.0618 64.5725 66.761 62.6577 65.6963 55.4815C69.8785 61.4097 71.7058 62.3131 78.2765 61.7004Z"
                    fill="#FF3A6E" />
            </svg>
            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                    fill="#FF3A6E"></path>
            </svg>
            <div class="info-icon-wrp d-flex flex-wrap align-items-start justify-content-between gap-2 mb-3">
                <div class="info-icon">
                    <svg width="26" height="25" viewBox="0 0 26 25" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_62_1820)">
                            <path
                                d="M6.0673 4.433C5.91859 4.51212 5.78085 4.61316 5.6598 4.73422L2.5094 7.88318C2.38739 8.00519 2.28587 8.14341 2.20675 8.29307C2.10619 8.48323 2.24488 8.71248 2.46031 8.71248H5.34285C5.97436 8.71248 6.48671 8.20013 6.48671 7.56862V4.68656C6.48671 4.47161 6.25746 4.33244 6.0673 4.433Z"
                                fill="white" />
                            <path
                                d="M7.82122 5.18495C7.82122 7.52748 9.72052 9.42678 12.0631 9.42678C14.4056 9.42678 16.3049 7.52748 16.3049 5.18495C16.3049 2.84241 14.4056 0.943115 12.0631 0.943115C9.72052 0.943115 7.82122 2.84241 7.82122 5.18495ZM15.1043 5.18495C15.1043 6.86214 13.7398 8.22619 12.0631 8.22619C10.3863 8.22619 9.02181 6.86166 9.02181 5.18495C9.02181 3.50823 10.3863 2.1437 12.0631 2.1437C13.7398 2.1437 15.1043 3.50823 15.1043 5.18495Z"
                                fill="white" />
                            <path
                                d="M3.72238 24.2019H16.1142C17.0617 24.2019 17.83 23.4336 17.83 22.4861V18.5164C17.83 18.3143 17.626 18.1761 17.4383 18.2509C17.1685 18.3577 16.6499 18.5493 15.4599 18.9978C14.6611 19.2985 13.8384 18.6336 13.9533 17.7957L14.2378 15.7177C14.3055 15.2235 14.5057 14.7559 14.8169 14.3661L17.7681 10.6657C17.8086 10.6151 17.8305 10.5522 17.8305 10.4874V5.94817C17.8305 5.35479 17.5293 4.83243 17.0713 4.52406C16.9702 4.4559 16.8349 4.53597 16.8482 4.65703C17.1647 7.49811 14.928 9.99888 12.0635 9.99888C9.1991 9.99888 6.82082 7.30556 7.31697 4.38251C7.34795 4.19996 7.05912 4.17518 7.05912 4.36154V7.56817C7.05912 8.51567 6.29083 9.28396 5.34333 9.28396H2.29302C2.13527 9.28396 2.00706 9.41217 2.00706 9.56993V22.4861C2.00706 23.4336 2.77535 24.2019 3.72285 24.2019H3.72238ZM8.41699 12.3819C8.41699 12.0659 8.67293 11.81 8.98892 11.81H14.2316C14.5476 11.81 14.8036 12.0659 14.8036 12.3819V12.7632C14.8036 13.0792 14.5476 13.3352 14.2316 13.3352H8.98892C8.67293 13.3352 8.41699 13.0792 8.41699 12.7632V12.3819ZM8.41699 16.2901C8.41699 15.9741 8.67293 15.7182 8.98892 15.7182H11.4673C11.7833 15.7182 12.0392 15.9741 12.0392 16.2901V16.6714C12.0392 16.9874 11.7833 17.2434 11.4673 17.2434H8.98892C8.67293 17.2434 8.41699 16.9874 8.41699 16.6714V16.2901ZM8.41699 20.1983C8.41699 19.8823 8.67293 19.6264 8.98892 19.6264H14.2316C14.5476 19.6264 14.8036 19.8823 14.8036 20.1983V20.5796C14.8036 20.8956 14.5476 21.1516 14.2316 21.1516H8.98892C8.67293 21.1516 8.41699 20.8956 8.41699 20.5796V20.1983ZM5.67648 11.81C6.0978 11.81 6.43905 12.1513 6.43905 12.5726C6.43905 12.9939 6.0978 13.3352 5.67648 13.3352C5.25516 13.3352 4.9139 12.9939 4.9139 12.5726C4.9139 12.1513 5.25516 11.81 5.67648 11.81ZM5.67648 15.7182C6.0978 15.7182 6.43905 16.0595 6.43905 16.4808C6.43905 16.9021 6.0978 17.2434 5.67648 17.2434C5.25516 17.2434 4.9139 16.9021 4.9139 16.4808C4.9139 16.0595 5.25516 15.7182 5.67648 15.7182ZM5.67648 19.6264C6.0978 19.6264 6.43905 19.9677 6.43905 20.389C6.43905 20.8103 6.0978 21.1516 5.67648 21.1516C5.25516 21.1516 4.9139 20.8103 4.9139 20.389C4.9139 19.9677 5.25516 19.6264 5.67648 19.6264Z"
                                fill="white" />
                            <path
                                d="M22.8464 11.1648L23.3144 10.5781C23.9459 9.7864 23.8248 8.6373 23.0489 7.9934C22.2482 7.32948 21.0395 7.47961 20.3909 8.29271L19.9457 8.85082C19.8966 8.91278 19.9066 9.00238 19.9681 9.05195L22.6457 11.1872C22.7077 11.2363 22.7973 11.2262 22.8468 11.1648H22.8464Z"
                                fill="white" />
                            <path
                                d="M18.6045 16.4839L22.3116 11.836C22.3607 11.774 22.3507 11.6844 22.2892 11.6349L19.6116 9.49966C19.5496 9.45057 19.46 9.46058 19.4105 9.52206L15.7034 14.1704C15.6543 14.2324 15.6643 14.322 15.7263 14.3716L18.4039 16.5068C18.4658 16.5559 18.5554 16.5459 18.605 16.4839H18.6045Z"
                                fill="white" />
                            <path
                                d="M18.0593 17.1577C18.115 17.0971 18.1065 17.0013 18.0421 16.9498L15.3741 14.8223C15.3097 14.7708 15.2139 14.7837 15.1677 14.8518C14.9751 15.133 14.8503 15.4562 14.8045 15.7945L14.52 17.8726C14.4633 18.2853 14.8684 18.6085 15.2582 18.4617L17.2209 17.722C17.5412 17.6014 17.8281 17.4079 18.0593 17.1572V17.1577Z"
                                fill="white" />
                            <path
                                d="M11.7771 3.54476V3.75685C11.3834 3.83787 11.086 4.1877 11.086 4.60521C11.086 5.08278 11.4744 5.47121 11.952 5.47121H12.1889C12.3509 5.47121 12.4829 5.60323 12.4829 5.76528C12.4829 5.92733 12.3509 6.05935 12.1889 6.05935H11.8371C11.7375 6.05935 11.656 5.97833 11.656 5.87824C11.656 5.72048 11.5278 5.59227 11.3701 5.59227C11.2123 5.59227 11.0841 5.72048 11.0841 5.87824C11.0841 6.27287 11.3896 6.59697 11.7766 6.62795V6.82526C11.7766 6.98302 11.9048 7.11123 12.0626 7.11123C12.2203 7.11123 12.3485 6.98302 12.3485 6.82526V6.61555C12.7498 6.54025 13.0549 6.18756 13.0549 5.76481C13.0549 5.28724 12.6664 4.8988 12.1889 4.8988H11.952C11.79 4.8988 11.6579 4.76678 11.6579 4.60474C11.6579 4.44269 11.79 4.31067 11.952 4.31067H12.3037C12.4034 4.31067 12.4849 4.39169 12.4849 4.49178C12.4849 4.64954 12.6131 4.77775 12.7708 4.77775C12.9286 4.77775 13.0568 4.64954 13.0568 4.49178C13.0568 4.0919 12.7432 3.76447 12.3485 3.74112V3.54476C12.3485 3.387 12.2203 3.25879 12.0626 3.25879C11.9048 3.25879 11.7766 3.387 11.7766 3.54476H11.7771Z"
                                fill="white" />
                        </g>
                        <defs>
                            <clipPath id="clip0_62_1820">
                                <rect width="24.4024" height="24.4024" fill="white"
                                    transform="translate(0.661587 0.371826)" />
                            </clipPath>
                        </defs>
                    </svg>
                </div>
                <div class="card-label">
                    {{ __('Most Purchase Plan : ') }}
                    <span>{{ $user['most_purchese_plan'] }}</span>
                </div>
            </div>
            <div class="info-content d-flex align-items-center gap-3 flex-wrap">
                <h2 class="h4 mb-0 info-link">{{ __('Total Plans') }}</h2>
                <h3 class="mb-0">{{ $user->total_plan }}</h3>
            </div>
        </div>
    </div>
</div>

    <div class="row">
        <div class="col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Recent Order') }}</h5>
                </div>
                <div class="card-body">
                    <div class="chart">
                        <div id="chart-sales" data-color="primary" data-height="280"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
