@extends('layouts.admin')
@section('page-title')
    {{__('Manage Payroll')}}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Payroll Report')}}</li>
@endsection
@push('script-page')
    <script type="text/javascript" src="{{ asset('js/jszip.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/pdfmake.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/vfs_fonts.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/dataTables.buttons.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/buttons.html5.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>

    <script>
        $('input[name="type"]:radio').on('change', function (e) {
            var type = $(this).val();
            if (type == 'monthly') {
                $('.month').addClass('d-block');
                $('.month').removeClass('d-none');
                $('.year').addClass('d-none');
                $('.year').removeClass('d-block');
            } else {
                $('.year').addClass('d-block');
                $('.year').removeClass('d-none');
                $('.month').addClass('d-none');
                $('.month').removeClass('d-block');
            }
        });

        $('input[name="type"]:radio:checked').trigger('change');

    </script>

    <script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
    <script>
        var filename = $('#filename').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {type: 'jpeg', quality: 1},
                html2canvas: {scale: 4, dpi: 72, letterRendering: true},
                jsPDF: {unit: 'in', format: 'A4'}
            };
            html2pdf().set(opt).from(element).save();
        }

        $(document).ready(function () {
            var filename = $('#filename').val();
            $('#report-dataTable').DataTable({
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'pdf',
                        title: filename
                    },
                    {
                        extend: 'excel',
                        title: filename
                    }, {
                        extend: 'csv',
                        title: filename
                    }
                ]
            });
        });
    </script>

    <script>

        $(document).ready(function () {
            var b_id = $('#branch_id').val();
        });
        $(document).on('change', 'select[name=branch_id]', function () {

            var branch_id = $(this).val();
            getDepartment(branch_id);
        });

        function getDepartment(bid) {

            $.ajax({
                url: '{{route('report.payroll.getdepartment')}}',
                type: 'POST',
                data: {
                    "branch_id": bid,
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data) {
                    $('#department_id').empty();
                    $("#department_div").html('');
                    $('#department_div').append('<label for="department" class="form-label">{{__('Department')}}</label><select class="form-control" id="department_id" name="department_id"  ></select>');
                    $('#department_id').append('<option value="">{{__('Select Department')}}</option>');
                    $.each(data, function (key, value) {
                        $('#department_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                }

            });
        }

        $(document).on('change', '#department_id', function () {
            var department_id = $(this).val();
            getEmployee(department_id);
        });

        function getEmployee(did) {
            $.ajax({
                url: '{{route('report.payroll.getemployee')}}',
                type: 'POST',
                data: {
                    "department_id": did,
                    "_token": "{{ csrf_token() }}",
                },
                success: function (data) {
                    $('#employee_id').empty();
                    $("#employee_div").html('');
                    $('#employee_div').append('<label for="employee" class="form-label">{{__('Employee')}}</label><select class="form-control" id="employee_id" name="employee_id"></select>');
                    $('#employee_id').append('<option value="">{{__('Select Employee')}}</option>');

                    $.each(data, function (key, value) {
                        $('#employee_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                }
            });
        }
    </script>
@endpush

@section('action-btn')
    <div class="float-end d-flex">
        <a href="{{ route('payroll.export') }}" data-bs-toggle="tooltip" title="{{ __('Export') }}"
           class="btn btn-sm btn-secondary me-2">
            <i class="ti ti-file-export"></i>
        </a>

        <a href="#" class="btn btn-sm btn-primary" onclick="saveAsPDF()"data-bs-toggle="tooltip" title="{{__('Download')}}" data-original-title="{{__('Download')}}">
            <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
        </a>
    </div>
@endsection

@section('content')

    <div class="row">
        <div class="col-sm-12">
            <div class=" mt-2 " id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        {{ Form::open(array('route' => array('report.payroll'),'method'=>'get','id'=>'report_payroll')) }}
                        <div class="row align-items-center justify-content-end">
                            <div class="col-md-2 mt-2">
                                <label class="form-label">{{__('Type')}}</label> <br>
                                <div class="form-check form-check-inline form-group">
                                    <input type="radio" id="monthly" value="monthly" name="type" class="form-check-input" {{isset($_GET['type']) && $_GET['type']=='monthly' ?'checked':'checked'}}>
                                    <label class="form-check-label" for="monthly">{{__('Monthly')}}</label>
                                </div>
                                <div class="form-check form-check-inline form-group">
                                    <input type="radio" id="daily" value="daily" name="type" class="form-check-input" {{isset($_GET['type']) && $_GET['type']=='daily' ?'checked':''}}>
                                    <label class="form-check-label" for="daily">{{__('Daily')}}</label>
                                </div>
                            </div>
                            <div class="col-md-2 month">
                                <div class="btn-box">
                                    {{Form::label('month',__('Month'),['class'=>'form-label'])}}
                                    {{Form::month('month',isset($_GET['month'])?$_GET['month']:date('Y-m'),array('class'=>'month-btn form-control'))}}
                                </div>
                            </div>
                            <div class="col-md-2 year d-none">
                                <div class="btn-box">
                                    {{ Form::label('year', __('Year'),['class'=>'form-label']) }}
                                    <select class="form-control select" id="year" name="year" tabindex="-1" aria-hidden="true">
                                        @for($filterYear['starting_year']; $filterYear['starting_year'] <= $filterYear['ending_year']; $filterYear['starting_year']++)
                                            <option {{(isset($_GET['year']) && $_GET['year'] == $filterYear['starting_year'] ?'selected':'')}} {{(!isset($_GET['year']) && date('Y') == $filterYear['starting_year'] ?'selected':'')}} value="{{$filterYear['starting_year']}}">{{$filterYear['starting_year']}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="btn-box">
                                    {{ Form::label('branch', __('Branch'),['class'=>'form-label']) }}
                                    <select class="form-control select" name="branch_id" id="branch_id"  placeholder="Select Branch" required>
                                        <option value="">{{__('Select Branch')}}</option>
                                        @foreach($branch as $branch)
                                            <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="btn-box" id="department_div">
                                    {{ Form::label('department', __('Department'),['class'=>'form-label'])}}
                                    <select class="form-control select" name="department_id" id="department_id" required="required">
                                        <option value="">{{__('Select Department')}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="btn-box" id="employee_div">
                                    {{ Form::label('employee', __('Employee'),['class'=>'form-label'])}}
                                    <select class="form-control select" name="employee_id" id="employee_id">
                                        <option value="">{{__('Select Employee')}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-auto mt-4">
                                <a href="#" class="btn btn-sm btn-primary me-1" onclick="document.getElementById('report_payroll').submit(); return false;" data-bs-toggle="tooltip" title="{{__('Apply')}}" data-original-title="{{__('apply')}}">
                                    <span class="btn-inner--icon"><i class="ti ti-search"></i></span>
                                </a>
                                <a href="{{route('report.payroll')}}" class="btn btn-sm btn-danger " data-bs-toggle="tooltip" title="{{ __('Reset') }}" data-original-title="{{__('Reset')}}">
                                    <span class="btn-inner--icon"><i class="ti ti-refresh text-white-off "></i></span>
                                </a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div id="printableArea" class="mt-2">
        <div class="row mt-3">
            <div class="col-sm-6 col-12 mb-4">
                <input type="hidden" value="{{  $filterYear['branch'] .' '.__('Branch') .' '.$filterYear['dateYearRange'].' '.$filterYear['type'].' '.__('Payroll Report of').' '. $filterYear['department'].' '.'Department'}}" id="filename">
                <div class="card report-card h-100 mb-0">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3.09766 0.761719V20.668C3.09766 21.089 3.43835 21.4297 3.85938 21.4297H17.5703C17.9913 21.4297 18.332 21.089 18.332 20.668V0.761719C18.332 0.340691 17.9913 0 17.5703 0H3.85938C3.43835 0 3.09766 0.340691 3.09766 0.761719ZM15.2852 17.5703H12.2383C11.8173 17.5703 11.4766 17.2296 11.4766 16.8086C11.4766 16.3876 11.8173 16.0469 12.2383 16.0469H15.2852C15.7062 16.0469 16.0469 16.3876 16.0469 16.8086C16.0469 17.2296 15.7062 17.5703 15.2852 17.5703ZM6.14453 3.85938H10.7148C11.1359 3.85938 11.4766 4.20007 11.4766 4.62109C11.4766 5.04212 11.1359 5.38281 10.7148 5.38281H6.14453C5.7235 5.38281 5.38281 5.04212 5.38281 4.62109C5.38281 4.20007 5.7235 3.85938 6.14453 3.85938ZM6.14453 6.90625H15.2852C15.7062 6.90625 16.0469 7.24694 16.0469 7.66797C16.0469 8.089 15.7062 8.42969 15.2852 8.42969H6.14453C5.7235 8.42969 5.38281 8.089 5.38281 7.66797C5.38281 7.24694 5.7235 6.90625 6.14453 6.90625ZM6.14453 9.95312H15.2852C15.7062 9.95312 16.0469 10.2938 16.0469 10.7148C16.0469 11.1359 15.7062 11.4766 15.2852 11.4766H6.14453C5.7235 11.4766 5.38281 11.1359 5.38281 10.7148C5.38281 10.2938 5.7235 9.95312 6.14453 9.95312ZM6.14453 13H15.2852C15.7062 13 16.0469 13.3407 16.0469 13.7617C16.0469 14.1827 15.7062 14.5234 15.2852 14.5234H6.14453C5.7235 14.5234 5.38281 14.1827 5.38281 13.7617C5.38281 13.3407 5.7235 13 6.14453 13Z"
                                    fill="white" />
                                <path
                                    d="M8.42969 26H22.1406C22.5617 26 22.9023 25.6593 22.9023 25.2383V5.38281C22.9023 4.96179 22.5617 4.62109 22.1406 4.62109H19.8555V20.668C19.8555 21.9281 18.8304 22.9531 17.5703 22.9531H7.66797V25.2383C7.66797 25.6593 8.00866 26 8.42969 26Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Report') }}</h5>
                            <p class="text-muted mb-0">{{ $filterYear['type'].' '.__('Payroll Summary') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @if($filterYear['branch']!='All')
                <div class="col-sm-6 col-12 mb-4">
                    <div class="card report-card h-100 mb-0">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.9998 0.8125C8.61229 0.8125 5.04541 4.38344 5.04541 8.76687C5.04541 13.1909 7.88916 17.4322 10.1195 20.0769C8.12072 20.4262 6.2276 21.2103 6.2276 22.5103C6.2276 24.2491 9.71729 25.1875 12.9998 25.1875C16.2823 25.1875 19.772 24.2491 19.772 22.5103C19.772 21.2103 17.8788 20.4262 15.8801 20.0769C18.1104 17.4322 20.9542 13.1909 20.9542 8.76687C20.9542 4.38344 17.3873 0.8125 12.9998 0.8125ZM12.9998 21.9538C11.6673 20.6781 5.85791 14.7794 5.85791 8.76687C5.85791 4.83031 9.05916 1.625 12.9998 1.625C16.9404 1.625 20.1417 4.83031 20.1417 8.76687C20.1417 14.7753 14.3323 20.6781 12.9998 21.9538Z" fill="white"/>
                                    <path d="M13.8168 3.25C13.8127 3.25 13.8046 3.24594 13.8005 3.24594C12.6549 3.07938 11.5621 3.26219 10.5668 3.7375C8.6168 4.66781 7.35742 6.66656 7.35742 8.83188C7.35742 9.08781 7.37773 9.34781 7.4143 9.59563V9.59969C7.52398 10.4122 7.80836 11.18 8.23492 11.8544C8.66148 12.5288 9.2343 13.1138 9.92086 13.5566C10.839 14.1538 11.8993 14.4706 13.0002 14.4706C13.374 14.4706 13.7437 14.43 14.1093 14.3569C14.1905 14.3406 14.2677 14.3203 14.349 14.3C14.6821 14.2188 15.0071 14.1131 15.3199 13.9709C16.043 13.6459 16.6971 13.1666 17.2334 12.5613C17.7818 11.9397 18.1962 11.1881 18.4237 10.3878C18.5699 9.88 18.643 9.35594 18.643 8.83188C18.643 6.045 16.5671 3.64406 13.8168 3.25ZM16.8637 11.7203C16.5549 11.5213 16.1974 11.3872 15.8399 11.3628C15.3687 11.3263 15.0071 11.4806 14.743 11.5944C14.5602 11.6756 14.4465 11.7244 14.3937 11.6959C14.3165 11.6594 14.2109 11.4806 14.158 11.0947C14.1093 10.7575 13.9184 10.4609 13.638 10.2863C13.3902 10.1359 13.1018 10.0872 12.8134 10.14C12.3218 10.2416 11.6027 10.4853 10.9649 11.0703C10.8187 11.2044 10.2255 11.7934 9.9168 12.545C9.19773 11.9519 8.67773 11.1638 8.40148 10.2781C8.76711 10.4041 9.14898 10.4772 9.53492 10.4772C9.85586 10.4772 10.1768 10.4325 10.4855 10.3391C10.9121 10.2131 11.2493 10.0222 11.493 9.76625C11.818 9.43313 11.9846 8.97813 11.9318 8.55563C11.9115 8.40125 11.8668 8.27531 11.7815 8.14531C11.7002 8.03563 11.6027 7.95844 11.5052 7.88938C11.3915 7.82031 11.2696 7.75938 11.1477 7.7025C10.973 7.61719 10.8187 7.54406 10.7374 7.4425C10.583 7.24344 10.6602 6.89 10.7821 6.61781C10.8349 6.50406 10.8918 6.39438 10.9487 6.28469C11.103 5.99219 11.2615 5.6875 11.3224 5.32188C11.363 5.06594 11.3468 4.68813 11.2534 4.33063C11.8059 4.11531 12.3909 4.00156 13.0002 4.00156H13.0652C12.9962 4.13563 12.9352 4.26969 12.8905 4.42C12.7402 4.91563 12.7971 5.41531 13.049 5.78906C13.2684 6.10188 13.5893 6.28063 13.8696 6.43906C14.1337 6.58531 14.3612 6.71125 14.4262 6.89C14.4871 7.0525 14.4343 7.26781 14.3693 7.51969C14.3327 7.66188 14.3002 7.80406 14.2799 7.94625C14.2109 8.40125 14.3002 8.85625 14.5237 9.22188C14.7755 9.63219 15.198 9.9125 15.653 9.97344C15.9455 10.0141 16.2299 9.96938 16.4818 9.92469C16.7662 9.87594 17.0099 9.83531 17.1765 9.93281C17.2659 9.98156 17.3552 10.0953 17.4487 10.2172C17.4812 10.2619 17.5137 10.3025 17.5543 10.3513C17.5584 10.3553 17.5665 10.3634 17.5705 10.3716C17.408 10.855 17.1684 11.3141 16.8637 11.7203Z" fill="white"/>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Branch') }}</h5>
                                <p class="text-muted mb-0">{{ $filterYear['branch'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            @if($filterYear['department']!='All')
                <div class="col-sm-6 col-12 mb-4">
                    <div class="card report-card h-100 mb-0">
                        <div class="card-body d-flex align-items-center gap-3">
                            <div class="report-icon">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_4436_1950)">
                                    <path d="M4.85177 18.8417C2.16578 18.8417 0 21.0075 0 23.6935C0 24.0438 0.0424662 24.373 0.100857 24.7074C1.44385 25.4081 3.07349 25.8221 4.84646 25.8221C6.61942 25.8221 8.25437 25.4081 9.59206 24.7074C9.65576 24.3783 9.69292 24.0492 9.69292 23.6935C9.72477 21.0287 7.53245 18.8417 4.85177 18.8417Z" fill="white"/>
                                    <path d="M4.85156 17.7217C6.26463 17.7217 7.41015 16.5762 7.41015 15.1631C7.41015 13.75 6.26463 12.6045 4.85156 12.6045C3.43849 12.6045 2.29297 13.75 2.29297 15.1631C2.29297 16.5762 3.43849 17.7217 4.85156 17.7217Z" fill="white"/>
                                    <path d="M21.1589 18.8417C18.4729 18.8417 16.3071 21.0075 16.3071 23.6935C16.3071 24.0438 16.3496 24.373 16.408 24.7074C17.751 25.4081 19.3806 25.8221 21.1536 25.8221C22.9266 25.8221 24.5615 25.4081 25.8992 24.7074C25.9629 24.3783 26 24.0492 26 23.6935C26.0107 21.0287 23.8449 18.8417 21.1589 18.8417Z" fill="white"/>
                                    <path d="M21.1587 17.7217C22.5718 17.7217 23.7173 16.5762 23.7173 15.1631C23.7173 13.75 22.5718 12.6045 21.1587 12.6045C19.7456 12.6045 18.6001 13.75 18.6001 15.1631C18.6001 16.5762 19.7456 17.7217 21.1587 17.7217Z" fill="white"/>
                                    <path d="M13.0055 13.4114C14.7785 13.4114 16.4134 12.9973 17.7511 12.2966C17.8148 11.9675 17.852 11.6384 17.852 11.2827C17.852 8.59676 15.6862 6.43098 13.0002 6.43098C10.3142 6.43098 8.14844 8.59676 8.14844 11.2827C8.14844 11.6331 8.1909 11.9622 8.24929 12.2966C9.5976 12.9973 11.2325 13.4114 13.0055 13.4114Z" fill="white"/>
                                    <path d="M13.0054 5.29501C14.4184 5.29501 15.564 4.14949 15.564 2.73642C15.564 1.32335 14.4184 0.177828 13.0054 0.177828C11.5923 0.177828 10.4468 1.32335 10.4468 2.73642C10.4468 4.14949 11.5923 5.29501 13.0054 5.29501Z" fill="white"/>
                                    <path d="M13.7061 17.5412V14.5845C13.7061 14.2925 13.4673 14.043 13.17 14.0484C12.8887 14.059 12.671 14.2819 12.671 14.5633V17.5359L10.2982 19.8875C10.0965 20.0892 10.0912 20.413 10.2876 20.62C10.4946 20.8323 10.845 20.827 11.052 20.6147L13.1647 18.502L15.3092 20.6253C15.5163 20.827 15.8454 20.827 16.0524 20.6253C16.2594 20.4183 16.2594 20.0839 16.0524 19.8822L13.7061 17.5412Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_4436_1950">
                                    <rect width="26" height="26" fill="white"/>
                                    </clipPath>
                                    </defs>
                                    </svg>
                                    
                            </div>
                            <div class="report-info flex-1">
                                <h5 class="mb-1">{{ __('Department') }}</h5>
                                <p class="text-muted mb-0">{{ $filterYear['department'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="col-sm-6 col-12 mb-4">
                <div class="card report-card h-100 mb-0">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.6667 5.22996V2.94866C22.3111 2.57293 22.75 1.8819 22.75 1.08332V0.541684C22.75 0.242277 22.5077 0 22.2083 0H3.79168C3.49228 0 3.25 0.242277 3.25 0.541684V1.08337C3.25 1.8819 3.68885 2.57293 4.33332 2.94871V5.22996C4.33332 7.37653 5.24845 9.43104 6.84384 10.8667L9.21416 13L6.84384 15.1333C5.24845 16.569 4.33332 18.6235 4.33332 20.77V23.0513C3.68885 23.4271 3.25 24.1181 3.25 24.9167V25.4584C3.25 25.7577 3.49228 26 3.79168 26H22.2084C22.5078 26 22.7501 25.7577 22.7501 25.4583V24.9166C22.7501 24.1181 22.3112 23.4271 21.6667 23.0513V20.77C21.6667 18.6235 20.7516 16.569 19.1562 15.1333L16.7858 13L19.1562 10.8667C20.7516 9.43104 21.6667 7.37648 21.6667 5.22996ZM17.7068 9.25646L14.442 12.1949C14.2135 12.4002 14.0833 12.6927 14.0833 13C14.0833 13.3073 14.2135 13.5999 14.442 13.8051L17.7068 16.7435C18.8462 17.7692 19.5 19.2371 19.5 20.77V22.75H18.1456L13.4332 16.4669C13.229 16.1939 12.7709 16.1939 12.5667 16.4669L7.85444 22.75H6.5V20.77C6.5 19.2371 7.15381 17.7692 8.29324 16.7435L11.5581 13.805C11.7866 13.5998 11.9167 13.3073 11.9167 12.9999C11.9167 12.6926 11.7866 12.4001 11.5581 12.1949L8.29324 9.25641C7.15381 8.23078 6.5 6.76289 6.5 5.22996V3.25H19.5V5.22996C19.5 6.76289 18.8462 8.23078 17.7068 9.25646Z" fill="white"/>
                                <path d="M16.7337 7.58332H9.26621C9.05197 7.58332 8.85783 7.70976 8.77109 7.90547C8.68436 8.10174 8.72082 8.33026 8.86524 8.48895L12.6368 11.9685C12.74 12.0622 12.8701 12.1087 13.0002 12.1087C13.1303 12.1087 13.2605 12.0621 13.3636 11.9685L17.1346 8.48895C17.279 8.33026 17.3155 8.10174 17.2288 7.90547C17.1421 7.70976 16.9479 7.58332 16.7337 7.58332Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Duration') }}</h5>
                            <p class="text-muted mb-0">{{ $filterYear['dateYearRange'] }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2024)">
                                <path d="M23.1943 15.9581L20.3131 19.7258C19.7366 20.4797 18.8418 20.9219 17.8928 20.9219H12.543C12.1223 20.9219 11.7812 20.5808 11.7812 20.1602C11.7812 19.7395 12.1223 19.3984 12.543 19.3984H17.1798C18.1763 19.3984 19.0109 18.5828 18.9919 17.5864C18.9734 16.6208 18.1849 15.8437 17.2148 15.8437H11.8828C10.3519 14.3718 7.98946 14.1995 6.26123 15.4339L5.6875 15.8437V24.4766H10.7656H11.7812H18.9345C20.4896 24.4766 21.938 23.6858 22.7789 22.3777L25.7516 17.7535C25.9138 17.5012 25.9999 17.2078 25.9999 16.9079C26 15.4126 24.1026 14.7703 23.1943 15.9581Z" fill="white"/>
                                <path d="M3.40234 14.3203H0.761719C0.341047 14.3203 0 14.6614 0 15.082V25.2383C0 25.659 0.341047 26 0.761719 26H3.40234C3.82302 26 4.16406 25.659 4.16406 25.2383V15.082C4.16406 14.6614 3.82302 14.3203 3.40234 14.3203Z" fill="white"/>
                                <path d="M14.5393 4.21002C14.3843 4.32885 14.2989 4.50877 14.2696 4.66482C14.229 4.88008 14.2803 5.08006 14.4004 5.1742C14.4427 5.20736 14.4893 5.23997 14.5393 5.27201V4.21002Z" fill="white"/>
                                <path d="M15.082 12.6953C18.5821 12.6953 21.4297 9.84775 21.4297 6.34766C21.4297 2.84756 18.5821 0 15.082 0C11.5819 0 8.73438 2.84756 8.73438 6.34766C8.73438 9.84775 11.5819 12.6953 15.082 12.6953ZM13.1605 8.42304C13.314 8.18843 13.6288 8.12241 13.8635 8.27607C14.1378 8.45548 14.3096 8.53328 14.5392 8.56553V6.42098C14.2148 6.27235 13.9724 6.1293 13.7735 5.97325C13.3521 5.64271 13.1597 5.06929 13.2713 4.47662C13.393 3.83079 13.8426 3.31693 14.4445 3.13564C14.4764 3.12604 14.5079 3.11726 14.5392 3.10898V2.79297C14.5392 2.51255 14.7666 2.28516 15.047 2.28516C15.3274 2.28516 15.5548 2.51255 15.5548 2.79297V3.05332C16.0478 3.13869 16.3963 3.38142 16.5651 3.57515C16.7493 3.78661 16.7272 4.10739 16.5157 4.29157C16.3054 4.47479 15.987 4.45397 15.8022 4.24562C15.7906 4.23389 15.7099 4.15619 15.5548 4.09896V5.7398C15.6449 5.77327 15.735 5.80572 15.8234 5.837C16.7161 6.15255 17.2126 6.97887 17.0589 7.89318C16.9394 8.60387 16.3986 9.3246 15.5548 9.53865V9.90234C15.5548 10.1828 15.3274 10.4102 15.047 10.4102C14.7666 10.4102 14.5392 10.1828 14.5392 9.90234V9.5874C14.1292 9.55195 13.7893 9.4412 13.3075 9.126C13.0728 8.97244 13.007 8.65775 13.1605 8.42304Z" fill="white"/>
                                <path d="M16.0572 7.72484C16.0906 7.52634 16.1042 7.05331 15.5547 6.8219V8.45305C15.8403 8.28943 16.011 8.00008 16.0572 7.72484Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2024">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Basic Salary') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalBasicSalary']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2033)">
                                <path d="M5.83984 18.3828C3.87979 18.3828 2.28516 16.7882 2.28516 14.8281C2.28516 12.8681 3.87979 11.2734 5.83984 11.2734C7.7999 11.2734 9.39453 12.8681 9.39453 14.8281C9.39453 16.7882 7.79995 18.3828 5.83984 18.3828Z" fill="white"/>
                                <path d="M11.2789 18.7531C12.151 19.1096 13.0932 19.2969 14.0663 19.2969C18.1264 19.2969 21.4296 15.9937 21.4296 11.9336C21.4296 7.87348 18.1264 4.57031 14.0663 4.57031C10.7177 4.57031 7.884 6.81708 6.99365 9.88234C9.23971 10.4062 10.9179 12.4249 10.9179 14.8281C10.9179 15.8814 10.5949 16.8604 10.0436 17.6725C10.4996 17.99 10.9127 18.353 11.2789 18.7531ZM14.0663 12.6953C12.5263 12.6953 11.2733 11.4424 11.2733 9.90234C11.2733 8.62636 12.1337 7.54833 13.3046 7.21581V6.85547C13.3046 6.4348 13.6456 6.09375 14.0663 6.09375C14.487 6.09375 14.828 6.4348 14.828 6.85547V7.21581C15.9989 7.54828 16.8593 8.62636 16.8593 9.90234C16.8593 10.323 16.5182 10.6641 16.0976 10.6641C15.6769 10.6641 15.3358 10.323 15.3358 9.90234C15.3358 9.20232 14.7663 8.63281 14.0663 8.63281C13.3663 8.63281 12.7968 9.20232 12.7968 9.90234C12.7968 10.6024 13.3663 11.1719 14.0663 11.1719C15.6064 11.1719 16.8593 12.4248 16.8593 13.9648C16.8593 15.2408 15.9989 16.3189 14.828 16.6514V17.0117C14.828 17.4324 14.487 17.7734 14.0663 17.7734C13.6456 17.7734 13.3046 17.4324 13.3046 17.0117V16.6514C12.1337 16.3189 11.2733 15.2408 11.2733 13.9648C11.2733 13.5442 11.6144 13.2031 12.0351 13.2031C12.4557 13.2031 12.7968 13.5442 12.7968 13.9648C12.7968 14.6649 13.3663 15.2344 14.0663 15.2344C14.7663 15.2344 15.3358 14.6649 15.3358 13.9648C15.3358 13.2648 14.7663 12.6953 14.0663 12.6953Z" fill="white"/>
                                <path d="M22.5047 3.49527C20.2507 1.2413 17.2539 0 14.0663 0C10.8788 0 7.882 1.2413 5.62803 3.49527C3.51304 5.61026 2.28977 8.37926 2.14697 11.3463C2.98943 10.4532 4.15116 9.86451 5.44775 9.76503C6.41818 5.90967 9.91407 3.04688 14.0663 3.04688C18.9665 3.04688 22.9531 7.03346 22.9531 11.9336C22.9531 16.8337 18.9665 20.8203 14.0663 20.8203C13.5545 20.8203 13.0498 20.7771 12.556 20.6933C12.9765 21.6276 13.2031 22.6534 13.2031 23.7148V23.8361C13.4897 23.8567 13.7776 23.8672 14.0663 23.8672C17.2539 23.8672 20.2507 22.6259 22.5047 20.3719C24.7586 18.1179 25.9999 15.1212 25.9999 11.9336C25.9999 8.746 24.7586 5.7492 22.5047 3.49527Z" fill="white"/>
                                <path d="M8.99595 18.8034C8.12871 19.4933 7.03168 19.9062 5.83984 19.9062C4.64806 19.9062 3.55098 19.4933 2.68374 18.8034C1.07042 19.8437 0 21.6566 0 23.7148V25.2383C0 25.659 0.341047 26 0.761719 26H10.918C11.3386 26 11.6797 25.659 11.6797 25.2383V23.7148C11.6797 21.6566 10.6093 19.8437 8.99595 18.8034Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2033">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Net Salary') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalNetSalary']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2040)">
                                <path d="M0.000294403 7.50736V15.0729C0.0007478 15.1543 0.022284 15.2343 0.0630895 15.3051L2.60028 19.6962C2.7227 19.9086 2.78685 20.1496 2.78595 20.3949V21.3572H9.2858V20.2346C9.2858 20.1464 9.26063 20.0602 9.21348 19.9859L6.38136 15.5367C6.29612 15.4028 6.14831 15.3216 5.98963 15.3216H5.35578C4.85818 15.3212 4.39821 15.0559 4.14862 14.6252L3.08088 12.7729C2.92423 12.4942 2.63202 12.3192 2.31238 12.3131L2.23779 12.3095C1.91294 12.3229 1.61868 12.5051 1.46204 12.7899C1.30539 13.0748 1.30924 13.421 1.47201 13.7023L3.88633 17.8835L3.08224 18.3478L0.667917 14.1657C0.370264 13.657 0.333085 13.0367 0.56817 12.4961C0.803255 11.9556 1.28227 11.5596 1.8574 11.4306V7.42893C1.85785 7.18273 1.75969 6.94651 1.58491 6.77286C1.39312 6.58357 1.12924 6.48519 0.860156 6.50287C0.358929 6.56861 -0.0119472 7.00206 0.000294403 7.50736Z" fill="white"/>
                                <path d="M1.39307 22.2857H10.6786V25.9999H1.39307V22.2857Z" fill="white"/>
                                <path d="M24.1892 12.4317C24.0598 12.3569 23.9138 12.3151 23.7644 12.3095L23.6891 12.3131C23.3702 12.3192 23.078 12.4938 22.9213 12.7719L21.8536 14.6252C21.604 15.0559 21.144 15.3211 20.6464 15.3216H20.0108C19.8521 15.3216 19.7043 15.4028 19.619 15.5367L16.7869 19.9859C16.7395 20.0602 16.7144 20.1464 16.7144 20.2346V21.3572H23.2142V20.3939C23.214 20.1496 23.2781 19.9093 23.4001 19.6975L25.9373 15.3078C25.9781 15.237 25.9996 15.157 25.9999 15.0756V7.50736C26.0123 7.00183 25.6412 6.56838 25.1395 6.50287C24.8707 6.48564 24.6073 6.58402 24.4152 6.77286C24.2405 6.94651 24.1423 7.18273 24.1428 7.42892V11.4306C24.7177 11.5593 25.1964 11.9547 25.4322 12.4945C25.6677 13.0345 25.6319 13.6542 25.3356 14.1634L22.9213 18.3482L22.1172 17.884L24.5313 13.7C24.7823 13.2546 24.6302 12.6903 24.1892 12.4317Z" fill="white"/>
                                <path d="M15.3213 22.2857H24.6068V25.9999H15.3213V22.2857Z" fill="white"/>
                                <path d="M18.1533 1.85762H7.8465C7.65902 2.76894 6.94697 3.481 6.03564 3.66848V6.54685C6.94697 6.73432 7.65902 7.44638 7.8465 8.35747H18.1533C18.3408 7.44638 19.0528 6.73432 19.9639 6.54685V3.66848C19.0528 3.481 18.3408 2.76894 18.1533 1.85762ZM9.74985 5.57182H7.89275V4.64327H9.74985V5.57182ZM12.9998 7.42892C11.7178 7.42892 10.6784 6.38975 10.6784 5.10755C10.6784 3.82558 11.7178 2.78617 12.9998 2.78617C14.282 2.78617 15.3211 3.82558 15.3211 5.10755C15.3198 6.38907 14.2813 7.42756 12.9998 7.42892ZM18.1068 5.57182H16.2497V4.64327H18.1068V5.57182Z" fill="white"/>
                                <path d="M14.3926 5.10755C14.3926 5.87696 13.7692 6.50037 12.9998 6.50037C12.2306 6.50037 11.6069 5.87696 11.6069 5.10755C11.6069 4.33837 12.2306 3.71472 12.9998 3.71472C13.7692 3.71472 14.3926 4.33837 14.3926 5.10755Z" fill="white"/>
                                <path d="M4.17871 0.000520706V10.2146H21.8212V0.000520706H4.17871ZM20.8926 7.42892H20.4283C19.6592 7.42892 19.0355 8.05257 19.0355 8.82175V9.28602H6.96436V8.82175C6.96436 8.05257 6.34095 7.42892 5.57154 7.42892H5.10726V2.78617H5.57154C6.34095 2.78617 6.96436 2.16276 6.96436 1.39335V0.929071H19.0355V1.39335C19.0355 2.16276 19.6592 2.78617 20.4283 2.78617H20.8926V7.42892Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2040">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Allowance') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalAllowance']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.0627 15.4375C17.0627 15.5982 17.015 15.7553 16.9257 15.8889C16.8364 16.0225 16.7095 16.1267 16.5611 16.1882C16.4126 16.2496 16.2493 16.2657 16.0916 16.2344C15.934 16.203 15.7893 16.1257 15.6756 16.012C15.562 15.8984 15.4846 15.7536 15.4533 15.596C15.4219 15.4384 15.438 15.275 15.4995 15.1266C15.561 14.9781 15.6651 14.8512 15.7988 14.7619C15.9324 14.6727 16.0895 14.625 16.2502 14.625C16.4656 14.625 16.6723 14.7106 16.8247 14.863C16.9771 15.0153 17.0627 15.222 17.0627 15.4375ZM10.5627 10.5625C10.5627 10.4018 10.515 10.2447 10.4257 10.1111C10.3364 9.97748 10.2095 9.87335 10.0611 9.81185C9.91262 9.75035 9.74925 9.73426 9.59164 9.76561C9.43403 9.79696 9.28926 9.87435 9.17563 9.98798C9.062 10.1016 8.98462 10.2464 8.95327 10.404C8.92192 10.5616 8.93801 10.725 8.9995 10.8734C9.061 11.0219 9.16514 11.1488 9.29875 11.2381C9.43237 11.3273 9.58946 11.375 9.75016 11.375C9.96564 11.375 10.1723 11.2894 10.3247 11.137C10.4771 10.9847 10.5627 10.778 10.5627 10.5625ZM23.0589 15.015C23.0532 15.0249 23.0502 15.0361 23.0502 15.0475C23.0502 15.0589 23.0532 15.0701 23.0589 15.08L23.4895 16.1525C23.6606 16.5661 23.6606 17.0307 23.4895 17.4444C23.4051 17.6501 23.2793 17.8363 23.12 17.9914C22.9606 18.1465 22.7712 18.2673 22.5633 18.3463L21.5883 18.7444V19.8494C21.5883 20.2976 21.4102 20.7274 21.0933 21.0444C20.7764 21.3613 20.3465 21.5394 19.8983 21.5394H18.6877L18.1839 22.6444C18.0113 23.0582 17.6821 23.3869 17.2681 23.5589C16.8541 23.7309 16.3889 23.7322 15.9739 23.5625L15.007 23.1481L14.1945 23.9038C13.8776 24.2203 13.4481 24.3981 13.0002 24.3981C12.5523 24.3981 12.1227 24.2203 11.8058 23.9038L10.9933 23.0913L9.85578 23.5138C9.44215 23.6848 8.97754 23.6848 8.5639 23.5138C8.3582 23.4293 8.17202 23.3035 8.01689 23.1442C7.86176 22.9849 7.74098 22.7954 7.66203 22.5875L7.26391 21.6125H6.15891C5.93697 21.6125 5.71721 21.5688 5.51217 21.4839C5.30713 21.3989 5.12083 21.2744 4.96389 21.1175C4.80696 20.9606 4.68248 20.7743 4.59755 20.5692C4.51262 20.3642 4.46891 20.1444 4.46891 19.9225V18.6875L3.36391 18.1838C2.94866 18.0127 2.61808 17.6842 2.44449 17.27C2.2709 16.8558 2.26844 16.3897 2.43766 15.9738L2.85203 15.0069L2.09641 14.1944C1.77986 13.8775 1.60205 13.4479 1.60205 13C1.60205 12.5521 1.77986 12.1225 2.09641 11.8056L2.90891 10.9931L2.48641 9.85563C2.31532 9.44199 2.31532 8.97738 2.48641 8.56375C2.57442 8.35255 2.70604 8.16231 2.87266 8.00549C3.03928 7.84868 3.23713 7.72881 3.45328 7.65375L4.42828 7.25563V6.15063C4.42824 5.92593 4.47301 5.70348 4.55996 5.49629C4.64692 5.28911 4.77431 5.10134 4.9347 4.94398C5.09509 4.78661 5.28525 4.66281 5.49406 4.57982C5.70287 4.49683 5.92613 4.4563 6.15078 4.46063H7.31265L7.81641 3.35563C7.98898 2.94185 8.31818 2.61311 8.73219 2.44111C9.14621 2.26911 9.61144 2.26782 10.0264 2.4375L10.9933 2.85188L11.8058 2.09625C12.1227 1.7797 12.5523 1.6019 13.0002 1.6019C13.4481 1.6019 13.8776 1.7797 14.1945 2.09625L15.007 2.90875L16.1445 2.48625C16.5582 2.31517 17.0228 2.31517 17.4364 2.48625C17.6421 2.57072 17.8283 2.69651 17.9834 2.85583C18.1385 3.01515 18.2593 3.20462 18.3383 3.4125L18.7527 4.42H19.8414C20.2896 4.42 20.7195 4.59805 21.0364 4.91499C21.3534 5.23193 21.5314 5.66178 21.5314 6.11V7.3125L22.6364 7.81625C23.0516 7.98728 23.3822 8.31583 23.5558 8.73001C23.7294 9.14419 23.7319 9.61027 23.5627 10.0263L23.1483 10.9931L23.9039 11.8056C24.2205 12.1225 24.3983 12.5521 24.3983 13C24.3983 13.4479 24.2205 13.8775 23.9039 14.1944L23.0589 15.015ZM9.75016 13C10.2322 13 10.7035 12.857 11.1044 12.5892C11.5052 12.3214 11.8176 11.9407 12.0021 11.4953C12.1866 11.0499 12.2349 10.5598 12.1408 10.087C12.0468 9.61414 11.8146 9.17982 11.4737 8.83893C11.1328 8.49804 10.6985 8.26589 10.2257 8.17184C9.75286 8.07779 9.26276 8.12606 8.81736 8.31054C8.37197 8.49503 7.99128 8.80745 7.72345 9.2083C7.45561 9.60914 7.31265 10.0804 7.31265 10.5625C7.31265 11.209 7.56946 11.829 8.02658 12.2861C8.4837 12.7432 9.10369 13 9.75016 13ZM16.9245 8.57188C16.9954 8.48383 17.0472 8.38196 17.0765 8.27277C17.1058 8.16358 17.112 8.04948 17.0947 7.93776C17.0774 7.82605 17.0369 7.71917 16.976 7.62397C16.915 7.52877 16.8348 7.44735 16.7406 7.3849C16.6463 7.32245 16.5401 7.28036 16.4287 7.26131C16.3172 7.24226 16.2031 7.24668 16.0934 7.27427C15.9838 7.30187 15.8811 7.35205 15.792 7.42159C15.7029 7.49113 15.6292 7.5785 15.5758 7.67813L9.07578 17.4281C8.95819 17.6073 8.91611 17.8256 8.95872 18.0356C9.00133 18.2456 9.12517 18.4302 9.30328 18.5494C9.43413 18.641 9.59042 18.6893 9.75016 18.6875C9.88398 18.6868 10.0156 18.6531 10.1332 18.5893C10.2509 18.5255 10.3509 18.4336 10.4245 18.3219L16.9245 8.57188ZM18.6877 15.4375C18.6877 14.9554 18.5447 14.4841 18.2769 14.0833C18.009 13.6825 17.6283 13.37 17.1829 13.1855C16.7376 13.0011 16.2475 12.9528 15.7746 13.0468C15.3018 13.1409 14.8675 13.373 14.5266 13.7139C14.1857 14.0548 13.9535 14.4891 13.8595 14.962C13.7654 15.4348 13.8137 15.9249 13.9982 16.3703C14.1827 16.8157 14.4951 17.1964 14.896 17.4642C15.2968 17.732 15.7681 17.875 16.2502 17.875C16.8966 17.875 17.5166 17.6182 17.9737 17.1611C18.4308 16.704 18.6877 16.084 18.6877 15.4375Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Commission') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalCommision']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.3017 4.12593L10.877 5.14892H11.727L11.3017 4.12593Z" fill="white"/>
                                <path d="M8.15265 5.8994C8.68596 5.8994 9.11829 5.44193 9.11829 4.8776C9.11829 4.31328 8.68596 3.8558 8.15265 3.8558C7.61934 3.8558 7.18701 4.31328 7.18701 4.8776C7.18701 5.44193 7.61934 5.8994 8.15265 5.8994Z" fill="white"/>
                                <path d="M10.5821 23.1944V22.5652V19.0916C10.2077 18.92 9.94251 18.5404 9.94251 18.0984V17.256H9.69807C9.19889 17.256 8.79327 16.8504 8.79327 16.346V15.3216C8.79327 14.9784 8.98047 14.682 9.25608 14.5312V13.4496C9.25608 13.304 9.2821 13.1636 9.33403 13.0284H7.56087C7.34251 13.0284 7.17087 12.8568 7.17087 12.6384C7.17087 12.4252 7.34251 12.2484 7.56087 12.2484H10.1817C11.2996 11.5464 12.6829 10.626 13.9309 9.80438H13.5148C13.2965 9.80438 13.1248 9.6276 13.1248 9.41438C13.1248 9.19599 13.2965 9.02438 13.5148 9.02438H15.1113C15.5896 8.70719 16.0005 8.44198 16.3021 8.24959C16.484 8.1352 16.6869 8.07798 16.9001 8.07798C17.1185 8.07798 17.3265 8.14038 17.5137 8.26L18.5381 8.92558V2.17079C18.5381 2.17079 18.5381 2.0824 18.5381 1.7912C18.5381 1.19839 18.0596 0.714792 17.4669 0.714792H2.84444C2.24649 0.714792 1.76807 1.19839 1.76807 1.7912V22.118C1.76807 22.7108 2.25169 23.1944 2.84444 23.1944H9.94252L10.5821 23.1944ZM13.2237 3.72038C13.2237 3.53318 13.3744 3.37719 13.5617 3.37719H13.6137C13.7229 3.37719 13.8217 3.42918 13.8996 3.52798L15.3037 5.5612V3.6424C15.3037 3.49161 15.4233 3.37719 15.5637 3.3824C15.7092 3.3824 15.8237 3.49678 15.8237 3.6424V6.03959C15.8237 6.22679 15.6729 6.3776 15.4805 6.3776H15.4337C15.3192 6.3776 15.2205 6.32038 15.1581 6.23719L13.7437 4.1936V6.1176C13.7437 6.26839 13.624 6.3776 13.4837 6.3776C13.3381 6.3776 13.2237 6.26839 13.2237 6.1176V3.72038ZM9.95286 6.00839L10.9773 3.59038C11.0344 3.46038 11.1385 3.3772 11.284 3.3772H11.3205C11.4661 3.3772 11.5701 3.46559 11.6273 3.59038L12.6517 6.00839C12.7296 6.20079 12.5996 6.3776 12.4177 6.3776C12.3085 6.3776 12.2201 6.31 12.1733 6.22161L11.934 5.63918H10.6705L10.4313 6.2164C10.3429 6.4036 10.114 6.42438 9.99965 6.29959C9.9321 6.23199 9.90608 6.12281 9.95286 6.00839ZM8.15368 3.3564C9.05848 3.3564 9.62526 4.0064 9.64088 4.87479C9.62526 5.7588 9.04807 6.39839 8.15368 6.39839C7.26965 6.39839 6.6821 5.78479 6.66649 4.88C6.6821 3.95959 7.28006 3.3564 8.15368 3.3564ZM4.48251 3.6424C4.48251 3.49678 4.5969 3.3824 4.74251 3.3824C4.88286 3.37719 5.00251 3.49161 5.00251 3.6424V5.83678H6.24005C6.38567 5.83678 6.50005 5.9564 6.50005 6.09678C6.50005 6.2476 6.38046 6.35678 6.24005 6.35678H4.81526C4.62807 6.35678 4.48252 6.2112 4.48252 6.02401L4.48251 3.6424ZM4.58649 9.02438H11.5961C11.8092 9.02438 11.9861 9.19599 11.9861 9.41438C11.9861 9.6276 11.8092 9.80438 11.5961 9.80438H4.58649C4.37328 9.80438 4.19649 9.6276 4.19649 9.41438C4.19649 9.19599 4.37327 9.02438 4.58649 9.02438ZM4.58649 12.2484H5.85006C6.06848 12.2484 6.24006 12.4252 6.24006 12.6384C6.24006 12.8568 6.06848 13.0284 5.85006 13.0284H4.58649C4.37328 13.0284 4.19649 12.8568 4.19649 12.6384C4.19649 12.4252 4.37327 12.2484 4.58649 12.2484ZM4.19649 15.8676C4.19649 15.6544 4.37328 15.4776 4.58649 15.4776H7.56088C7.77403 15.4776 7.95088 15.6544 7.95088 15.8676C7.95088 16.086 7.77403 16.2576 7.56088 16.2576H4.58649C4.37327 16.2576 4.19649 16.086 4.19649 15.8676ZM8.66848 20.9428C8.56965 21.1352 8.33047 21.208 8.14327 21.104C7.73706 20.8835 7.3699 20.3785 7.15006 20.48C7.10694 20.5016 7.0632 20.5486 6.90047 20.688C6.65088 20.8908 6.36485 20.9584 6.11526 20.8648C5.87608 20.7712 5.75129 20.5632 5.68368 20.4488L5.43924 20.038C5.3769 20.4696 5.27807 20.896 5.15327 21.3172C5.09729 21.5163 4.88318 21.6382 4.66965 21.5772C4.4617 21.5148 4.34731 21.3016 4.40965 21.0936C4.58649 20.4956 4.70088 19.8768 4.74766 19.258C4.76327 19.024 4.92965 18.8264 5.15848 18.7744C5.39251 18.7224 5.62649 18.8212 5.74608 19.0292L6.35444 20.0536C6.35964 20.064 6.37005 20.0848 6.38567 20.1004C6.39087 20.0952 6.39608 20.09 6.40649 20.0848C6.46465 20.0383 6.62489 19.8558 6.83807 19.7676C7.60364 19.426 8.18051 20.235 8.51251 20.4176C8.69965 20.5164 8.77251 20.7556 8.66848 20.9428Z" fill="white"/>
                                <path d="M24.1041 15.1917H9.70036C9.62959 15.1917 9.57227 15.249 9.57227 15.3198V16.3475C9.57227 16.4182 9.62959 16.4756 9.70036 16.4756H24.1041C24.1749 16.4756 24.2322 16.4182 24.2322 16.3475V15.3198C24.2322 15.249 24.1749 15.1917 24.1041 15.1917Z" fill="white"/>
                                <path d="M16.7181 8.91C15.4337 9.7212 12.2045 11.9156 10.1974 13.1636C10.0985 13.226 10.0361 13.33 10.0361 13.4496V14.4116H23.7641V13.4444C23.7641 13.33 23.707 13.2208 23.6133 13.1584L17.0874 8.9152C16.9729 8.8424 16.8326 8.83719 16.7181 8.91ZM17.8802 11.9516C17.8802 12.493 17.4411 12.9321 16.8997 12.9321C16.3644 12.9321 15.9252 12.493 15.9252 11.9516C15.9252 11.4162 16.3644 10.9771 16.8997 10.9771C17.4411 10.9771 17.8802 11.4162 17.8802 11.9516Z" fill="white"/>
                                <path d="M23.7664 24.5052H23.0816V24.0509C23.0816 23.8763 22.94 23.7347 22.7654 23.7347H22.4433V18.4156H22.7659C22.9375 18.4156 23.0831 18.2752 23.0831 18.0984V17.256H20.1815V18.0984C20.1815 18.2752 20.3219 18.4156 20.4935 18.4156H20.8155V23.7347H20.4955C20.3209 23.7347 20.1793 23.8763 20.1793 24.0509V24.5052H13.6246V24.0509C13.6246 23.8763 13.4831 23.7347 13.3084 23.7347H12.9893V18.4156H13.3071C13.4839 18.4156 13.6242 18.2752 13.6242 18.0984V17.256H10.7227V18.0984C10.7227 18.2752 10.8631 18.4156 11.0398 18.4156H11.3615V23.7347H11.0386C10.8639 23.7347 10.7223 23.8763 10.7223 24.0509V24.5052H10.0384C9.82313 24.5052 9.64844 24.6799 9.64844 24.8952C9.64844 25.1105 9.82313 25.2852 10.0384 25.2852C11.5517 25.2852 24.4181 25.2852 23.7664 25.2852C23.9817 25.2852 24.1564 25.1105 24.1564 24.8952C24.1564 24.6799 23.9817 24.5052 23.7664 24.5052Z" fill="white"/>
                                <path d="M16.904 21.9796C16.9035 21.9796 16.9027 21.9796 16.902 21.9796C16.7816 21.9796 16.6681 21.9329 16.5823 21.8481C16.4962 21.7625 16.4485 21.6488 16.448 21.5274C16.447 21.3126 16.2725 21.1392 16.058 21.1392C16.0575 21.1392 16.057 21.1392 16.0562 21.1392C15.8409 21.1402 15.667 21.3154 15.668 21.5309C15.6695 21.8605 15.7993 22.1698 16.0334 22.4018C16.1702 22.5375 16.3347 22.6322 16.5123 22.6914L16.5132 22.9236C16.5143 23.1387 16.6884 23.3118 16.9032 23.3118H16.9048C17.1203 23.3113 17.294 23.1356 17.2932 22.9206L17.2923 22.691C17.4731 22.6306 17.6403 22.5335 17.7785 22.3942C18.0105 22.1601 18.1377 21.8498 18.1362 21.52C18.1347 21.1904 18.0049 20.8812 17.7708 20.6491C17.5397 20.42 17.234 20.2939 16.9091 20.292C16.9079 20.292 16.9069 20.2914 16.9058 20.2914C16.9048 20.2914 16.9036 20.2912 16.9022 20.2914C16.9021 20.2914 16.9023 20.2913 16.9022 20.2914C16.7819 20.2914 16.6681 20.2447 16.5823 20.1598C16.4962 20.0743 16.4485 19.9605 16.448 19.8392C16.4475 19.7181 16.4942 19.6038 16.5795 19.5175C16.6651 19.4314 16.7788 19.3837 16.9002 19.3831H16.9022C17.0226 19.3831 17.1361 19.4299 17.2219 19.5147C17.308 19.6002 17.3557 19.714 17.3562 19.8354C17.3572 20.0502 17.5317 20.2236 17.7462 20.2236H17.748C17.9633 20.2226 18.1372 20.0474 18.1362 19.8318C18.1347 19.5022 18.0049 19.193 17.7708 18.9609C17.634 18.8253 17.4694 18.7305 17.2919 18.6713L17.2909 18.4473C17.2899 18.2322 17.1155 18.0588 16.9009 18.0588C16.9004 18.0588 16.8999 18.0588 16.8994 18.0588C16.6839 18.0598 16.5099 18.235 16.5109 18.4503L16.5118 18.6718C16.3311 18.7321 16.1639 18.8292 16.0257 18.9685C15.7937 19.2026 15.6665 19.5129 15.668 19.8427C15.6695 20.1723 15.7993 20.4816 16.0334 20.7136C16.2645 20.9428 16.5702 21.0689 16.8951 21.0707C16.8963 21.0707 16.8973 21.0714 16.8984 21.0714C16.8991 21.0709 16.9 21.0711 16.902 21.0714C17.0223 21.0714 17.1361 21.1181 17.2219 21.2029C17.308 21.2885 17.3557 21.4022 17.3562 21.5236C17.3567 21.6447 17.31 21.759 17.2247 21.8453C17.1391 21.9314 17.0254 21.9791 16.904 21.9796Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Loan') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalLoan']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16.9977 12.5938C17.6826 11.6457 17.995 10.4788 17.8752 9.31531L17.668 7.41406C17.6584 7.33243 17.6243 7.25563 17.5701 7.1938C17.5159 7.13198 17.4443 7.08805 17.3646 7.0678C17.285 7.04755 17.201 7.05195 17.1239 7.08041C17.0468 7.10886 16.9801 7.16004 16.9327 7.22719C15.7952 8.85219 10.388 16.5709 9.39677 17.9887L8.79146 18.0944C8.35768 18.174 7.94548 18.3439 7.58157 18.5931C7.21765 18.8422 6.91014 19.165 6.67896 19.5406C5.24489 21.5109 6.78052 24.4156 9.18958 24.3709C11.5986 24.3263 12.8905 21.9334 11.9846 19.7681C12.7849 18.6225 16.9977 12.5938 16.9977 12.5938ZM12.6752 15.6325C12.783 15.6325 12.8863 15.6753 12.9625 15.7515C13.0387 15.8277 13.0815 15.931 13.0815 16.0387C13.0815 16.1465 13.0387 16.2498 12.9625 16.326C12.8863 16.4022 12.783 16.445 12.6752 16.445C12.5675 16.445 12.4641 16.4022 12.3879 16.326C12.3118 16.2498 12.269 16.1465 12.269 16.0387C12.269 15.931 12.3118 15.8277 12.3879 15.7515C12.4641 15.6753 12.5675 15.6325 12.6752 15.6325ZM10.3149 22.0919C9.14896 23.6803 6.95927 22.1853 8.06021 20.5116C9.21802 18.9231 11.4158 20.4222 10.3149 22.0919Z" fill="white"/>
                                <path d="M15.7586 20.7187C15.1655 21.1575 15.9455 22.2666 16.5711 21.8522C17.1967 21.4378 16.3883 20.3125 15.7586 20.7187Z" fill="white"/>
                                <path d="M8.72648 20.9788C8.2146 21.7384 9.13273 22.36 9.64866 21.6247C10.1646 20.8894 9.26273 20.2434 8.72648 20.9788Z" fill="white"/>
                                <path d="M23.0669 1.625H2.93311C2.82536 1.625 2.72203 1.6678 2.64584 1.74399C2.56966 1.82017 2.52686 1.92351 2.52686 2.03125V13C2.52686 13.1077 2.56966 13.2111 2.64584 13.2873C2.72203 13.3634 2.82536 13.4062 2.93311 13.4062H11.6025L12.8822 11.5781H6.59748C6.48974 11.5781 6.3864 11.5353 6.31022 11.4591C6.23403 11.383 6.19123 11.2796 6.19123 11.1719C6.19809 10.983 6.16586 10.7947 6.09657 10.6188C6.02729 10.4429 5.92243 10.2832 5.78857 10.1497C5.65471 10.0163 5.49473 9.91186 5.31865 9.84308C5.14257 9.77429 4.95419 9.74261 4.76529 9.75C4.65755 9.75 4.55422 9.7072 4.47803 9.63101C4.40184 9.55483 4.35904 9.45149 4.35904 9.34375V5.6875C4.35904 5.57976 4.40184 5.47642 4.47803 5.40024C4.55422 5.32405 4.65755 5.28125 4.76529 5.28125C4.95419 5.28865 5.14257 5.25696 5.31865 5.18817C5.49473 5.11939 5.65471 5.01499 5.78857 4.88151C5.92243 4.74803 6.02729 4.58835 6.09657 4.41246C6.16586 4.23658 6.19809 4.04829 6.19123 3.85938C6.19123 3.75163 6.23403 3.6483 6.31022 3.57211C6.3864 3.49593 6.48974 3.45312 6.59748 3.45312H19.4025C19.5102 3.45312 19.6136 3.49593 19.6897 3.57211C19.7659 3.6483 19.8087 3.75163 19.8087 3.85938C19.8151 4.24082 19.972 4.60429 20.2452 4.8706C20.5184 5.13692 20.8857 5.28452 21.2672 5.28125C21.3692 5.28944 21.4643 5.33583 21.5336 5.41114C21.6029 5.48646 21.6412 5.58516 21.6409 5.6875V9.34375C21.6409 9.45149 21.5981 9.55483 21.5219 9.63101C21.4457 9.7072 21.3424 9.75 21.2347 9.75C21.0458 9.74261 20.8574 9.77429 20.6813 9.84308C20.5052 9.91186 20.3453 10.0163 20.2114 10.1497C20.0775 10.2832 19.9727 10.4429 19.9034 10.6188C19.8341 10.7947 19.8019 10.983 19.8087 11.1719C19.8087 11.2796 19.7659 11.383 19.6897 11.4591C19.6136 11.5353 19.5102 11.5781 19.4025 11.5781H18.4194C18.1837 12.2359 17.8465 12.8528 17.42 13.4062H23.0669C23.1746 13.4062 23.2779 13.3634 23.3541 13.2873C23.4303 13.2111 23.4731 13.1077 23.4731 13V2.03125C23.4731 1.92351 23.4303 1.82017 23.3541 1.74399C23.2779 1.6678 23.1746 1.625 23.0669 1.625Z" fill="white"/>
                                <path d="M16.5589 18.0903L15.9576 17.9887L15.0842 16.7456L13.1707 19.5L13.3698 19.7844C13.2219 20.2134 13.1225 20.6576 13.0732 21.1087V21.2591V21.385C13.1098 23.7494 15.9657 25.2647 17.9239 23.8225C18.5921 23.3553 19.0478 22.6422 19.191 21.8395C19.3342 21.0368 19.1531 20.21 18.6876 19.5406C18.4557 19.162 18.146 18.8369 17.779 18.5868C17.412 18.3368 16.9961 18.1676 16.5589 18.0903ZM17.022 22.5347C15.4864 23.5381 13.8492 21.1331 15.2954 20.0687C16.7823 19.0937 18.4926 21.4256 17.022 22.5347Z" fill="white"/>
                                <path d="M9.48584 14.2269L10.2577 15.3319L11.0337 14.2269H9.48584Z" fill="white"/>
                                <path d="M19.0245 10.7738C19.0874 10.3188 19.2979 9.89701 19.6238 9.57332C19.9497 9.24964 20.3729 9.04196 20.8283 8.98219V6.04094C20.3843 5.96397 19.9746 5.75237 19.6549 5.43482C19.3352 5.11726 19.1208 4.7091 19.0408 4.26562H6.97514C6.91359 4.72114 6.70346 5.14362 6.37733 5.46754C6.0512 5.79147 5.62731 5.99873 5.17139 6.05719V8.97406C5.62704 9.03458 6.04999 9.24376 6.37464 9.56915C6.6993 9.89454 6.90752 10.318 6.96701 10.7738H13.467L16.2498 6.76406C16.3586 6.60256 16.5057 6.47053 16.678 6.37979C16.8502 6.28904 17.0423 6.24241 17.237 6.24406C17.5421 6.24282 17.8366 6.35606 18.0622 6.56141C18.2879 6.76675 18.4283 7.04926 18.4558 7.35313L18.6873 9.22594C18.7431 9.74177 18.7253 10.2629 18.6345 10.7738H19.0245ZM13.0201 7.1175C13.2926 7.12018 13.5556 7.21787 13.7637 7.39371C13.9718 7.56955 14.1121 7.81252 14.1602 8.0807C14.2083 8.34887 14.1614 8.62544 14.0274 8.8627C13.8935 9.09996 13.6809 9.28302 13.4264 9.38031C13.4264 9.48806 13.3836 9.59139 13.3074 9.66757C13.2312 9.74376 13.1279 9.78656 13.0201 9.78656C12.9124 9.78656 12.8091 9.74376 12.7329 9.66757C12.6567 9.59139 12.6139 9.48806 12.6139 9.38031C12.3937 9.29883 12.203 9.15297 12.0668 8.96169C11.9306 8.77042 11.8551 8.54258 11.8501 8.30781C11.8501 8.20007 11.8929 8.09674 11.9691 8.02055C12.0453 7.94436 12.1486 7.90156 12.2564 7.90156C12.3641 7.90156 12.4675 7.94436 12.5436 8.02055C12.6198 8.09674 12.6626 8.20007 12.6626 8.30781C12.6635 8.37799 12.6849 8.44638 12.7243 8.50444C12.7637 8.56251 12.8194 8.60769 12.8843 8.63436C12.9492 8.66102 13.0206 8.66798 13.0894 8.65438C13.1583 8.64077 13.2216 8.60721 13.2715 8.55786C13.3214 8.50851 13.3557 8.44556 13.37 8.37687C13.3844 8.30817 13.3782 8.23676 13.3523 8.17155C13.3264 8.10633 13.2818 8.05019 13.2242 8.01013C13.1666 7.97007 13.0984 7.94785 13.0283 7.94625C12.7529 7.94887 12.4855 7.85392 12.2734 7.67823C12.0613 7.50254 11.9183 7.25746 11.8696 6.9864C11.8209 6.71533 11.8698 6.43579 12.0075 6.19731C12.1452 5.95882 12.3629 5.77678 12.622 5.68344V5.63469C12.6285 5.52694 12.6775 5.42618 12.7582 5.35456C12.839 5.28295 12.9449 5.24635 13.0526 5.25281C13.1604 5.25928 13.2611 5.30828 13.3328 5.38904C13.4044 5.46979 13.441 5.57569 13.4345 5.68344C13.6576 5.76665 13.8501 5.91574 13.9866 6.11092C14.123 6.30609 14.1968 6.53813 14.1983 6.77625C14.1983 6.88399 14.1555 6.98733 14.0793 7.06351C14.0031 7.1397 13.8998 7.1825 13.792 7.1825C13.6843 7.1825 13.5809 7.1397 13.5047 7.06351C13.4286 6.98733 13.3858 6.88399 13.3858 6.77625C13.3873 6.70438 13.3671 6.63371 13.3278 6.57349C13.2886 6.51326 13.2321 6.46627 13.1657 6.43864C13.0993 6.41102 13.0262 6.40405 12.9558 6.41864C12.8854 6.43323 12.821 6.46871 12.7711 6.52043C12.7212 6.57216 12.688 6.63774 12.6759 6.70861C12.6638 6.77948 12.6734 6.85234 12.7034 6.91769C12.7333 6.98304 12.7823 7.03784 12.8439 7.07493C12.9055 7.11203 12.9768 7.12969 13.0486 7.12563L13.0201 7.1175Z" fill="white"/>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Saturation Deduction') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalSaturationDeduction']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2076)">
                                <path d="M24.8828 4.875C24.8828 4.40362 24.6956 3.95154 24.3622 3.61823C24.0289 3.28491 23.5768 3.09766 23.1055 3.09766H1.77734C1.30596 3.09766 0.853889 3.28491 0.520572 3.61823C0.187255 3.95154 0 4.40362 0 4.875L0 6.42789H24.8828V4.875Z" fill="white"/>
                                <path d="M14.8281 12.8644C14.8288 12.2586 15.0698 11.6777 15.4982 11.2493C15.9266 10.8209 16.5074 10.5799 17.1133 10.5793C17.814 10.5805 18.4976 10.3626 19.0684 9.95617L19.8529 9.39758C20.2395 9.12305 20.7019 8.97557 21.176 8.97557C21.6502 8.97557 22.1126 9.12305 22.4991 9.39758L23.2832 9.95617C23.7552 10.2929 24.3062 10.5018 24.8828 10.5625V7.95133H0V18.5976C0 19.069 0.187255 19.5211 0.520572 19.8544C0.853889 20.1877 1.30596 20.375 1.77734 20.375H15.8686C15.1839 19.1238 14.826 17.72 14.8281 16.2937V12.8644ZM3.47801 11.5177H3.97566C4.07569 11.5177 4.17475 11.5374 4.26716 11.5757C4.35958 11.614 4.44355 11.6701 4.51428 11.7408C4.58501 11.8115 4.64112 11.8955 4.6794 11.9879C4.71768 12.0803 4.73738 12.1794 4.73738 12.2794C4.73738 12.3794 4.71768 12.4785 4.6794 12.5709C4.64112 12.6633 4.58501 12.7473 4.51428 12.818C4.44355 12.8888 4.35958 12.9449 4.26716 12.9832C4.17475 13.0214 4.07569 13.0411 3.97566 13.0411H3.47801C3.37798 13.0411 3.27893 13.0214 3.18651 12.9832C3.09409 12.9449 3.01012 12.8888 2.93939 12.818C2.86866 12.7473 2.81255 12.6633 2.77427 12.5709C2.73599 12.4785 2.71629 12.3794 2.71629 12.2794C2.71629 12.1794 2.73599 12.0803 2.77427 11.9879C2.81255 11.8955 2.86866 11.8115 2.93939 11.7408C3.01012 11.6701 3.09409 11.614 3.18651 11.5757C3.27893 11.5374 3.37798 11.5177 3.47801 11.5177ZM9.9968 16.3008H3.47801C3.27599 16.3008 3.08224 16.2205 2.93939 16.0777C2.79654 15.9348 2.71629 15.7411 2.71629 15.5391C2.71629 15.337 2.79654 15.1433 2.93939 15.0004C3.08224 14.8576 3.27599 14.7773 3.47801 14.7773H9.9968C10.1988 14.7773 10.3926 14.8576 10.5354 15.0004C10.6783 15.1433 10.7585 15.337 10.7585 15.5391C10.7585 15.7411 10.6783 15.9348 10.5354 16.0777C10.3926 16.2205 10.1988 16.3008 9.9968 16.3008ZM9.9968 13.0411H6.96363C6.76161 13.0411 6.56787 12.9609 6.42502 12.818C6.28217 12.6752 6.20191 12.4814 6.20191 12.2794C6.20191 12.0774 6.28217 11.8836 6.42502 11.7408C6.56787 11.5979 6.76161 11.5177 6.96363 11.5177H9.9968C10.1988 11.5177 10.3926 11.5979 10.5354 11.7408C10.6783 11.8836 10.7585 12.0774 10.7585 12.2794C10.7585 12.4814 10.6783 12.6752 10.5354 12.818C10.3926 12.9609 10.1988 13.0411 9.9968 13.0411Z" fill="white"/>
                                <path d="M25.2383 12.1027C24.2216 12.1044 23.2297 11.7882 22.4016 11.1983L21.6166 10.6397C21.4878 10.5483 21.3337 10.4992 21.1758 10.4992C21.0178 10.4992 20.8638 10.5483 20.735 10.6397L19.9499 11.1983C19.1218 11.7882 18.13 12.1044 17.1133 12.1027C16.9113 12.1027 16.7175 12.1829 16.5747 12.3258C16.4318 12.4686 16.3516 12.6624 16.3516 12.8644V16.2937C16.3515 17.7217 16.7882 19.1156 17.603 20.2883C18.4178 21.4611 19.5718 22.3565 20.9102 22.8546C21.0815 22.9183 21.27 22.9183 21.4414 22.8546C22.7797 22.3565 23.9337 21.4611 24.7486 20.2883C25.5634 19.1156 26.0001 17.7217 26 16.2937V12.8644C26 12.6624 25.9197 12.4686 25.7769 12.3258C25.634 12.1829 25.4403 12.1027 25.2383 12.1027ZM23.271 16.1576L21.4256 18.2523C21.3541 18.3334 21.2662 18.3984 21.1677 18.4429C21.0691 18.4875 20.9622 18.5105 20.8541 18.5105C20.7459 18.5105 20.6391 18.4875 20.5405 18.4429C20.442 18.3984 20.354 18.3334 20.2825 18.2523L19.0805 16.8883C19.0144 16.8132 18.9637 16.7259 18.9314 16.6312C18.899 16.5365 18.8857 16.4364 18.892 16.3365C18.9048 16.1349 18.9972 15.9466 19.1488 15.813C19.3005 15.6795 19.499 15.6117 19.7006 15.6245C19.9023 15.6373 20.0906 15.7297 20.2241 15.8813L20.8538 16.5963L22.1274 15.1506C22.261 14.9989 22.4493 14.9065 22.6509 14.8937C22.8526 14.8809 23.0511 14.9487 23.2027 15.0823C23.3544 15.2158 23.4468 15.4041 23.4596 15.6058C23.4724 15.8074 23.4046 16.0059 23.271 16.1576Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2076">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Other Payment') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalOtherPayment']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 col-xl-3 mb-4">
                <div class="card report-card mb-0 h-100">
                    <div class="card-body d-flex align-items-center gap-3">
                        <div class="report-icon">
                            <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4436_2082)">
                                <path d="M5.87602 14.768C2.91202 14.768 0.52002 17.16 0.52002 20.124C0.52002 23.088 2.91202 25.48 5.87602 25.48C8.84002 25.48 11.232 23.088 11.232 20.124C11.232 17.16 8.84002 14.768 5.87602 14.768ZM6.08402 19.76C6.34402 19.864 7.48802 20.176 7.48802 21.268C7.48802 21.632 7.33202 22.412 6.24002 22.516V23.14H5.72002V22.516C5.30402 22.464 4.94002 22.308 4.68002 22.048C4.42002 21.788 4.31602 21.424 4.31602 21.008H5.25202C5.25202 21.684 5.72002 21.788 5.92802 21.788C6.13602 21.788 6.55202 21.684 6.55202 21.216C6.55202 20.748 6.13602 20.592 5.92802 20.54C5.72002 20.436 4.52402 20.176 4.52402 19.032C4.52402 18.668 4.68002 17.888 5.77202 17.732V17.056H6.29202V17.732C6.65602 17.784 7.48802 17.992 7.48802 19.188H6.55202C6.60402 18.564 6.13602 18.408 5.98002 18.408C5.51202 18.408 5.40802 18.772 5.40802 18.98C5.40802 19.448 5.82402 19.656 6.08402 19.76Z" fill="white"/>
                                <path d="M21.8399 4.16C16.9519 -0.675999 9.0479 -0.675999 4.15991 4.16C0.935906 7.384 -0.156094 11.96 0.883906 16.068C2.07991 14.612 3.84791 13.676 5.87591 13.676C9.41191 13.676 12.2719 16.536 12.2719 20.072C12.2719 22.1 11.3359 23.868 9.87991 25.064C13.9879 26.104 18.5639 25.012 21.7879 21.788C26.6759 16.952 26.6759 9.048 21.8399 4.16ZM3.32791 13.364H2.02791V12.636H3.32791V13.364ZM4.47191 8.476L3.32791 7.8L3.69191 7.176L4.83591 7.852L4.47191 8.476ZM7.85191 4.836L7.22791 3.692L7.85191 3.328L8.52791 4.472L7.85191 4.836ZM22.3079 7.176L22.6719 7.8L21.5799 8.476L21.2159 7.852L22.3079 7.176ZM18.1479 3.328L18.8239 3.692L18.1479 4.836L17.5239 4.472L18.1479 3.328ZM12.6359 2.028H13.3639V3.328H12.6359V2.028ZM11.9599 5.72C11.9599 5.148 12.4279 4.68 12.9999 4.68C13.5719 4.68 14.0399 5.148 14.0399 5.72V10.088C13.7279 9.984 13.3639 9.932 12.9999 9.932C12.6359 9.932 12.2719 9.984 11.9599 10.088V5.72ZM13.3639 23.92H12.6359V22.62H13.3639V23.92ZM12.9999 15.028C11.8559 15.028 10.9719 14.092 10.9719 13C10.9719 11.856 11.9079 10.972 12.9999 10.972C14.1439 10.972 15.0279 11.908 15.0279 13C15.0279 14.144 14.1439 15.028 12.9999 15.028ZM18.1479 22.672L17.5239 21.58L18.1479 21.216L18.8239 22.36L18.1479 22.672ZM15.9119 14.04C16.0159 13.728 16.0679 13.364 16.0679 13C16.0679 12.636 16.0159 12.272 15.9119 11.96H20.7479C21.0079 11.96 21.2679 12.064 21.4759 12.272C21.6839 12.428 21.7879 12.688 21.7879 13C21.7879 13.572 21.3199 14.04 20.7479 14.04H15.9119ZM22.3079 18.772L21.1639 18.096L21.5279 17.472L22.6199 18.148L22.3079 18.772ZM22.6719 13.364V12.636H23.9719V13.364H22.6719Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4436_2082">
                                <rect width="26" height="26" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>
                                
                        </div>
                        <div class="report-info flex-1">
                            <h5 class="mb-1">{{ __('Total Overtime') }}</h5>
                            <p class="text-muted mb-0">{{ \Auth::user()->priceFormat($filterData['totalOverTime']) }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable mb-0" id="report-dataTable">
                            <thead>
                            <tr>
                                <th>{{__('Employee ID')}}</th>
                                <th>{{__('Employee')}}</th>
                                <th>{{__('Salary')}}</th>
                                <th>{{__('Net Salary')}}</th>
                                <th>{{__('Month')}}</th>
                                <th>{{__('Status')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($payslips as $payslip)
                                <tr>
                                    <td><a href="{{route('employee.show',\Illuminate\Support\Facades\Crypt::encrypt($payslip->employee_id))}}" class="btn btn-sm btn-outline-primary">{{ !empty($payslip->employees)?\Auth::user()->employeeIdFormat($payslip->employees->employee_id):'' }}</a></td>
                                    <td>{{(!empty($payslip->employees)) ? $payslip->employees->name:''}}</td>
                                    <td>{{\Auth::user()->priceFormat($payslip->basic_salary)}}</td>
                                    <td>{{\Auth::user()->priceFormat($payslip->net_payble)}}</td>
                                    <td>{{$payslip->salary_month}}</td>
                                    <td>
                                        @if($payslip->status==0)
                                            <div class="badge status_badge bg-danger p-2 px-3 rounded"><a href="#" class="text-white">{{__('UnPaid')}}</a></div>
                                        @else
                                            <div class="badge status_badge bg-success p-2 px-3 rounded"><a href="#" class="text-white">{{__('Paid')}}</a></div>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

